<?php
// Get the error message from the URL parameter (if set)
$error_message = isset($_GET['error']) ? $_GET['error'] : 'An unknown error occurred.';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Error</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            text-align: center;
            margin-top: 50px;
        }
        .error-message {
            background-color: #f8d7da;
            color: #721c24;
            padding: 15px;
            margin: 20px;
            border-radius: 5px;
            display: inline-block;
        }
        .btn {
            background-color: #007bff;
            color: white;
            padding: 25px 45px;
            text-decoration: none;
            border-radius: 5px;
            margin-top: 10px;
            font-weight: 600;
        }
        .btn:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>

    <div class="error-message">
        <p><strong>Error:</strong> <?php echo htmlspecialchars($error_message); ?></p>
    </div>
    <br>
    <br>
    <a href="https://hireexamace.com/" class="btn">Go Back to Website</a>
    

</body>
</html>
